/*
 * Decompiled with CFR 0.152.
 */
package com.diamondgoobird.trialspawnertimer;

import com.diamondgoobird.trialspawnertimer.Timer;
import com.diamondgoobird.trialspawnertimer.TimerHandler;
import com.diamondgoobird.trialspawnertimer.TrialSpawnerTimer;
import java.awt.Color;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_8961;
import net.minecraft.class_898;
import org.joml.Matrix4f;

public class TimerRenderer {
    public static boolean drawTimer(class_1937 world1, class_8961 be, class_4587 matrixStack, class_4597 vertexConsumerProvider, class_898 entityRenderDispatcher, int light) {
        long current;
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        assert (world1 != null);
        Timer ti = TimerHandler.getTimer(world1, be.method_11016());
        if (ti == null) {
            return false;
        }
        long end = ti.getTimerEnd();
        long left = Math.max(end - (current = world1.method_8510()), 0L);
        if (left == 0L) {
            TimerHandler.deleteTime(world1, be.method_11016());
            return false;
        }
        double minutes = (double)left / 1200.0;
        double seconds = (minutes - Math.floor(minutes)) * 60.0;
        class_2561 t = class_2561.method_30163((String)String.format("%02d:%02d", (int)minutes, (int)seconds));
        int c = TimerRenderer.getColor((double)left / (double)ti.getCooldown());
        if (TrialSpawnerTimer.getConfig().isBrighterText()) {
            light = 0xF000F0;
        }
        TimerRenderer.drawTextAboveBlock(t, c, matrixStack, entityRenderDispatcher, vertexConsumerProvider, light);
        return true;
    }

    private static int getColor(double progress) {
        if (TrialSpawnerTimer.getConfig().getChromaTimer()) {
            return Color.getHSBColor((float)progress / 2.0f, 1.0f, 1.0f).getRGB();
        }
        return Color.MAGENTA.getRGB();
    }

    public static void drawTextAboveBlock(class_2561 t, int color, class_4587 matrixStack, class_898 entityRenderDispatcher, class_4597 vertexConsumerProvider, int light) {
        class_327 r = class_310.method_1551().field_1772;
        float width = r.method_27525((class_5348)t);
        matrixStack.method_46416(0.5f, 1.25f, 0.5f);
        matrixStack.method_22907(entityRenderDispatcher.method_24197());
        class_4587.class_4665 entry = matrixStack.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        matrix4f.rotate((float)Math.PI, 0.0f, 1.0f, 0.0f);
        matrix4f.scale(-0.025f, -0.025f, -0.025f);
        r.method_27522(t, -width / 2.0f, 0.0f, color, true, matrix4f, vertexConsumerProvider, TimerRenderer.getRenderType(), 0, light);
    }

    public static class_327.class_6415 getRenderType() {
        return TrialSpawnerTimer.getConfig().getSeeThroughWalls() ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993;
    }
}

