/*
 * Decompiled with CFR 0.152.
 */
package com.diamondgoobird.trialspawnertimer;

import com.diamondgoobird.trialspawnertimer.Timer;
import com.diamondgoobird.trialspawnertimer.TrialSpawnerTimer;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;
import net.minecraft.class_8967;

public class TimerHandler {
    private static final HashMap<class_5321<class_1937>, HashMap<class_2338, Timer>> timers = new HashMap();

    public static boolean shouldReset(class_8967 state) {
        return !TrialSpawnerTimer.ACCEPTABLE_STATES.contains(state);
    }

    public static boolean shouldCreate(class_8967 state) {
        return !TimerHandler.shouldReset(state);
    }

    public static boolean hasTimer(class_1937 world, class_2338 pos) {
        return TimerHandler.getTimer(world, pos) != null;
    }

    public static void insertTime(class_1937 world, class_2338 pos, long time, long cooldown) {
        HashMap t = timers.computeIfAbsent((class_5321<class_1937>)world.method_27983(), k -> new HashMap());
        t.put(pos, new Timer(time, cooldown));
        TrialSpawnerTimer.LOGGER.info("Timer added at block {} in {} ending {} minutes from now", new Object[]{pos, world.method_27983().method_29177(), Duration.of(cooldown, ChronoUnit.SECONDS).toMinutes() / 20L});
    }

    public static Timer getTimer(class_1937 world, class_2338 pos) {
        HashMap<class_2338, Timer> t = timers.get(world.method_27983());
        if (t == null) {
            return null;
        }
        return t.get(pos);
    }

    public static void deleteTime(class_1937 world, class_2338 pos) {
        HashMap<class_2338, Timer> t = timers.get(world.method_27983());
        if (t == null) {
            return;
        }
        Timer ti = t.remove(pos);
        if (ti != null) {
            long timeLeft = Duration.of(ti.getTimerEnd() - world.method_8510(), ChronoUnit.SECONDS).toMinutes() / 20L;
            TrialSpawnerTimer.LOGGER.info("Timer removed at block {} in {} with {} minutes left", new Object[]{pos, world.method_27983().method_29177(), timeLeft});
        }
        if (t.isEmpty()) {
            timers.remove(world.method_27983());
        }
    }
}

